<?php

require('../fpdf.php');
include_once 'dompdf/dompdf_config.inc.php';

class Page_invoice extends FPDF {

    var $client_name = '';
    var $newspaper = '';
    var $insertion_dates = '';
    var $classification = '';
    var $caption = '';
    var $rate_size = '';
    var $add_rate = '';
    var $add_amount = '';
    var $commision = '';
    var $net_value = '';
    var $vat = '';
    var $total_value = '';
    var $instructions = '';
    var $invoice_date = '';
    var $invoice_no = '';
    var $additional_rate = '';

    function generateInvoicePDF($invoice_id) {
        $dt = date("Y-m-d");
        $dates = preg_split("/[,]/", $this->insertion_dates);

        $html = '<html>
<table style="width:260mm; font-size: 14px;" border="0" cellspacing="0" cellpadding="5">
  <tr>
    <td colspan="4" align="center">
    	<p style="font-size: 24px; padding:0; margin:0; margin-bottom:5px"><strong>SRI SUGATHA ADVERTISIN AGENCY</strong></p>
      <p style="text-decoration:none; border-bottom:solid 1px #000000; padding-bottom:2px; margin:0">No 326, Oppisite the Court, Colombo Rd, Alawwa. Tel : 037 2278664, Fax : 037 2279438, Email : sugatha@srisugatha.com</p>
    	<p style="padding-top:2px; margin:0; font-size:12px">BR No කෑ/ව/002764</p>
    </td>
  </tr>
  <tr>
  	<td colspan="4" height="10"></td>
  </tr>
  <tr>
    <td colspan="2" valign="top">
      <table style="width:150mm; font-size: 14px;" border="0" cellspacing="5" cellpadding="5">
          <tr>
            <td valign="top" width="29%">Client :</td>
            <td valign="top" width="71%">' . $this->client_name . '</td>
          </tr>
          <tr>
            <td valign="top">Classification / Position :</td>
            <td valign="top">' . $this->classification . '</td>
          </tr>
          <tr>
            <td valign="top">Caption :</td>
            <td valign="top">' . $this->caption . '</td>
          </tr>
          <tr valign="top">
            <td valign="top">Size :</td>
            <td valign="top">' . $this->rate_size . '</td>
          </tr>
          <tr>
            <td valign="top">Rate :</td>
            <td valign="top">' . $this->add_rate . '</td>
          </tr>
        </table>
    </td>
    <td width="250" colspan="2" valign="top" >
        <table style="width:8cm; font-size: 14px;" border="1" cellspacing="5" cellpadding="5">
          <tr>
            <td valign="top" width="44%">Date :</td>
            <td valign="top" width="56%">' . $dt . '</td>
          </tr>
          <tr>
            <td valign="top">RO No :</td>
            <td valign="top">' . $this->invoice_no . '</td>
          </tr>
          <tr>
            <td valign="top">Publication :</td>
            <td valign="top">' . $this->newspaper . '</td>
          </tr>
          <tr>
            <td valign="top">Date of publications :</td>
            <td valign="top">';

        foreach ($dates as &$dt) {
            $html.=$dt . '<br>';
        }

        $html.= '</td>
          </tr>
          <tr>
            <td valign="top"></td>
            <td valign="top"></td>
          </tr>
          <tr>
            <td valign="top">Amount :</td>
            <td valign="top">' . $this->add_amount . '</td>
          </tr>
          <tr>
            <td valign="top">Commision :</td>
            <td valign="top">' . $this->compress . '</td>
          </tr>
          <tr>
            <td valign="top">Net :</td>
            <td valign="top">' . $this->net_value . '</td>
          </tr>
          <tr>
            <td valign="top">Vat :</td>
            <td valign="top">' . $this->vat . '</td>
          </tr>
          <tr>
            <td valign="top">Additional :</td>
            <td valign="top">' . $this->additional_rate . '</td>
          </tr>
    </table>
    </td>
  </tr>
  <tr>
    <td valign="top" style="padding-left:15px">Remarks :</td>
    <td valign="top">' . $this->instructions . '</td>
    <td valign="top" style="padding-left:15px">Total</td>
    <td valign="top">' . $this->total_value . '/=</td>
  </tr>
  <tr>
    <td valign="bottom" style="padding-left:15px" align="center" height="100">
    	<p style="border-top:dotted 1px #000000">Authorised by</p>
    </td>
    <td valign="top">&nbsp;</td>
    <td valign="top" style="padding-left:15px">&nbsp;</td>
    <td valign="top">&nbsp;</td>
  </tr>
  <tr>
    <td valign="bottom">&nbsp;</td>
    <td valign="bottom" colspan="3"><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="22%" align="right">E &amp; OE  &nbsp;&nbsp;&nbsp;&nbsp;</td>
        <td width="3%">1 :</td>
        <td width="75%">Payment within 30 days</td>
      </tr>
      <tr>
        <td>&nbsp;</td>
        <td>2 :</td>
        <td>All Cheques, Mos, Pos, should be drawn in favor of Sri Sugatha Advertising Agency.</td>
      </tr>
    </table></td>
  </tr>
</table>            
</html>';

        $dompdf = new DOMPDF();
        $dompdf->load_html($html);
        $dompdf->set_paper('A4', "landscape");
        $dompdf->render();
        $pdf = $dompdf->output();
        file_put_contents("../pdf_output/" . $invoice_id . ".pdf", $pdf);
    }

    function Header() {
        $this->Image('../images/InvoiceHeader.jpg', 10, 8, 190);
        $this->SetFont('Arial', 'B', 15);
        $this->SetFont('Arial', 'B', 11);

        $this->Cell(30, 10, $this->invoice_date);
        $this->Cell(95);
        $this->Cell(30, 10, 'Invoice No : ' . $this->invoice_no);
        $this->Ln(20);
        $this->SetLineWidth(0.4);
        $this->Line(10, 50, 200, 50);
        $this->Ln(20);

        $this->bodyPart();
    }

    function bodyPart() {
        $this->SetFont('Arial', '', 9);

        $this->writeLine(64, "Client", $this->client_name);
        $this->writeLine(70, "Newspaper", $this->newspaper);
        $this->writeLine(76, "Date of Insertion", $this->insertion_dates);
        $this->writeLine(82, "Classification / Position", $this->classification);
        $this->writeLine(88, "Caption", $this->caption);
        $this->writeLine(94, "Size", $this->rate_size);
        $this->writeLine(100, "Rate", $this->add_rate);

        $this->writePriceLines(120, "Amount", $this->add_amount . "/=");
        $this->writePriceLines(126, "Less 15% Agency commision", $this->commision . "/=");
        $this->writePriceLines(132, "Net", $this->net_value . "/=");
        $this->writePriceLines(138, "Vat", $this->vat . "/=");
        $this->writePriceLines(144, "Additional", $this->additional_rate . "/=");
        $this->writePriceLines(150, "Total Payable", $this->total_value . "/=");

        $this->writeLine(165, "Special Instructions", $this->instructions);

        $this->Image('../images/sig.jpg', 15, 200, 30);
        $this->Text(22, 225, "Manager");
        $this->ZoomMode = 100;
    }

    function writeLine($y, $key, $value) {
        $this->Text(15, $y, $key);
        $this->Text(65, $y, ":");
        $this->Text(80, $y, $value);
    }

    function writePriceLines($y, $key, $value) {
        $this->Text(45, $y, $key);
        $this->Text(95, $y, ":");
        $this->Text(100, $y, $value);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

}

?>