<?php

require('../fpdf.php');

class Image_report_generator extends FPDF {

    
//Page header
    function Header() {
        //Logo
        $this->Image('../images/InvoiceHeader.jpg', 10, 8, 190);
        //Arial bold 15
        $this->SetFont('Arial', 'B', 15);
        //Move to the right
        //$this->Cell(120);
        //Title
        $this->SetFont('Arial', 'B', 11);
        $this->Cell(30, 10, 'Title');
        $this->Cell(120);
        $this->Cell(30, 10, 'Invoice No :');
        $this->Ln(20);
        $this->SetLineWidth(0.4);
        $this->Line(10, 50, 200, 50);
        $this->Ln(20);

        $this->bodyPart();
    }

    function bodyPart() {
        $this->SetFont('Arial', '', 9);

        $this->writeLine(64, "Client", "Raden Ehsan Jayman");
        $this->writeLine(70, "Newspaper", "Lankadeepa");
        $this->writeLine(76, "Date of Insertion", "2010-10-28, 2010-10-30");
        $this->writeLine(82, "Classification / Position", "Position comes here");
        $this->writeLine(88, "Caption", "Caption");
        $this->writeLine(94, "Size", "Size");
        $this->writeLine(100, "Rate", "rate");

        $this->writePriceLines(120, "Amount", "10000/=");
        $this->writePriceLines(126, "Less 15% Agency commision", "1500/=");
        $this->writePriceLines(132, "Net", "8500/=");
        $this->writePriceLines(138, "Vat", "1200/=");
        $this->writePriceLines(144, "Total Payable", "9700/=");

        $this->writeLine(165, "Special Instructions", "No instructions");

        $this->Image('../images/sig.jpg', 15, 200, 30);
        $this->Text(22, 245, "Manager");
        $this->ZoomMode = 100;
    }

    function writeLine($y, $key, $value) {
        $this->Text(15, $y, $key);
        $this->Text(65, $y, ":");
        $this->Text(80, $y, $value);
    }

    function writePriceLines($y, $key, $value) {
        $this->Text(45, $y, $key);
        $this->Text(95, $y, ":");
        $this->Text(100, $y, $value);
    }

//Page footer
    function Footer() {
        //Position at 1.5 cm from bottom
        $this->SetY(-15);
        //Arial italic 8
        $this->SetFont('Arial', 'I', 8);
        //Page number
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

}

//Instanciation of inherited class
$pdf = new Image_report_generator();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times', '', 12);
$pdf->Output('../pdf_output/test5.pdf', 'F');
?>